<?php
class WareconnAPIClient {

    /**
     * 送交參數
     * @param $url 接口路徑
     * @param $method 存取方法GET|POST|PUT|DELETE
     * @param $params
     */
    public function request($url,$method,$params){
        $query = json_encode($params);
        
        $options = array(
            'http' => array(
                'header' => "Content-Type: application/json\r\n".
                    "Content-Length: ".strlen($query)."\r\n".
                    "User-Agent:MyAgent/1.0\r\n",
                'method'    => strtoupper($method),
                'content'   => $query
            )
        );

        $context = stream_context_create($options);

        $json = file_get_contents($url, false, $context);
        
        if($json){
            return json_decode($json, true);
        }else{
            return false;
        }
    }

}
